/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.worldnewsapi.v1.operation.newswebsitetorssfeed;

import com.nodepit.nodes.worldnewsapi.v1.ResponseMapper;
import com.nodepit.nodes.worldnewsapi.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class NewsWebsiteToRSSFeedNodeSettings {
    private static final String URL_KEY = "url";
    private static final String URL_DEFAULT_VALUE = null;
    private String url = URL_DEFAULT_VALUE;
    private static final String ANALYZE_KEY = "analyze";
    private static final boolean ANALYZE_DEFAULT_VALUE = false;
    private boolean analyze = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    NewsWebsiteToRSSFeedNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(URL_KEY, this.url);
        settings.addBoolean(ANALYZE_KEY, this.analyze);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.url = settings.getString(URL_KEY, URL_DEFAULT_VALUE);
        this.analyze = settings.getBoolean(ANALYZE_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.url == null || this.url.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cURL\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String url() {
        return this.url;
    }

    void url(String value) {
        this.url = value;
    }

    boolean analyze() {
        return this.analyze;
    }

    void analyze(boolean value) {
        this.analyze = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

