/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.worldnewsapi.v1.operation.topnews;

import com.nodepit.nodes.worldnewsapi.v1.ResponseMapper;
import com.nodepit.nodes.worldnewsapi.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class TopNewsNodeSettings {
    private static final String SOURCE_COUNTRY_KEY = "sourceCountry";
    private static final String SOURCE_COUNTRY_DEFAULT_VALUE = null;
    private String sourceCountry = SOURCE_COUNTRY_DEFAULT_VALUE;
    private static final String LANGUAGE_KEY = "language";
    private static final String LANGUAGE_DEFAULT_VALUE = null;
    private String language = LANGUAGE_DEFAULT_VALUE;
    private static final String DATE_KEY = "date";
    private static final String DATE_DEFAULT_VALUE = null;
    private String date = DATE_DEFAULT_VALUE;
    private static final String DATE_ENABLED_KEY = "dateEnabled";
    private boolean dateEnabled = false;
    private static final String HEADLINES_ONLY_KEY = "headlinesOnly";
    private static final boolean HEADLINES_ONLY_DEFAULT_VALUE = false;
    private boolean headlinesOnly = false;
    private static final String HEADLINES_ONLY_ENABLED_KEY = "headlinesOnlyEnabled";
    private boolean headlinesOnlyEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    TopNewsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(SOURCE_COUNTRY_KEY, this.sourceCountry);
        settings.addString(LANGUAGE_KEY, this.language);
        settings.addString(DATE_KEY, this.date);
        settings.addBoolean(DATE_ENABLED_KEY, this.dateEnabled);
        settings.addBoolean(HEADLINES_ONLY_KEY, this.headlinesOnly);
        settings.addBoolean(HEADLINES_ONLY_ENABLED_KEY, this.headlinesOnlyEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.sourceCountry = settings.getString(SOURCE_COUNTRY_KEY, SOURCE_COUNTRY_DEFAULT_VALUE);
        this.language = settings.getString(LANGUAGE_KEY, LANGUAGE_DEFAULT_VALUE);
        this.date = settings.getString(DATE_KEY, DATE_DEFAULT_VALUE);
        this.dateEnabled = settings.getBoolean(DATE_ENABLED_KEY, false);
        this.headlinesOnly = settings.getBoolean(HEADLINES_ONLY_KEY, false);
        this.headlinesOnlyEnabled = settings.getBoolean(HEADLINES_ONLY_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.sourceCountry == null || this.sourceCountry.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cSource Country\u201d is required.");
        }
        if (this.language == null || this.language.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cLanguage\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String sourceCountry() {
        return this.sourceCountry;
    }

    void sourceCountry(String value) {
        this.sourceCountry = value;
    }

    String language() {
        return this.language;
    }

    void language(String value) {
        this.language = value;
    }

    String date() {
        return this.date;
    }

    void date(String value) {
        this.date = value;
    }

    boolean dateEnabled() {
        return this.dateEnabled;
    }

    void dateEnabled(boolean value) {
        this.dateEnabled = value;
    }

    boolean headlinesOnly() {
        return this.headlinesOnly;
    }

    void headlinesOnly(boolean value) {
        this.headlinesOnly = value;
    }

    boolean headlinesOnlyEnabled() {
        return this.headlinesOnlyEnabled;
    }

    void headlinesOnlyEnabled(boolean value) {
        this.headlinesOnlyEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

