/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.worldnewsapi.v1.timeout;

import com.nodepit.nodes.worldnewsapi.v1.timeout.TimeoutNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class TimeoutNodeDialog
extends NodeDialogPane {
    private final TimeoutNodeSettings nodeSettings = new TimeoutNodeSettings();
    private JSpinner connectTimeout;
    private JSpinner readTimeout;
    private JSpinner writeTimeout;

    TimeoutNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 13;
        panel.add((Component)new JLabel("Connect Timeout:"), c);
        ++c.gridx;
        this.connectTimeout = new JSpinner(new SpinnerNumberModel(10, 0, Integer.MAX_VALUE, 1));
        TimeoutNodeDialog.setColumns(this.connectTimeout);
        panel.add((Component)this.connectTimeout, c);
        ++c.gridx;
        panel.add((Component)new JLabel("Seconds"), c);
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 13;
        panel.add((Component)new JLabel("Read Timeout:"), c);
        ++c.gridx;
        this.readTimeout = new JSpinner(new SpinnerNumberModel(10, 0, Integer.MAX_VALUE, 1));
        TimeoutNodeDialog.setColumns(this.readTimeout);
        panel.add((Component)this.readTimeout, c);
        ++c.gridx;
        panel.add((Component)new JLabel("Seconds"), c);
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 13;
        panel.add((Component)new JLabel("Write Timeout:"), c);
        ++c.gridx;
        this.writeTimeout = new JSpinner(new SpinnerNumberModel(10, 0, Integer.MAX_VALUE, 1));
        TimeoutNodeDialog.setColumns(this.writeTimeout);
        panel.add((Component)this.writeTimeout, c);
        ++c.gridx;
        panel.add((Component)new JLabel("Seconds"), c);
        return panel;
    }

    private static void setColumns(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        JFormattedTextField textField = ((JSpinner.DefaultEditor)editor).getTextField();
        textField.setColumns(10);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        if (this.connectTimeout.getValue() == null) {
            throw new InvalidSettingsException("Value for connect timeout is required.");
        }
        if (this.readTimeout.getValue() == null) {
            throw new InvalidSettingsException("Value for read timeout is required.");
        }
        if (this.writeTimeout.getValue() == null) {
            throw new InvalidSettingsException("Value for write timeout is required.");
        }
        this.nodeSettings.connectTimeout(((Number)this.connectTimeout.getValue()).intValue());
        this.nodeSettings.readTimeout(((Number)this.readTimeout.getValue()).intValue());
        this.nodeSettings.writeTimeout(((Number)this.writeTimeout.getValue()).intValue());
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.connectTimeout.setValue(this.nodeSettings.connectTimeout());
        this.readTimeout.setValue(this.nodeSettings.readTimeout());
        this.writeTimeout.setValue(this.nodeSettings.writeTimeout());
    }
}

