/*
 * Decompiled with CFR 0.152.
 */
package org.knime.okhttp3;

import java.io.IOException;
import java.util.Locale;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class OkHttpProxyAuthenticator
implements Authenticator {
    private static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";
    private static final String PROXY_USER = ".proxyUser";
    private static final String PROXY_PASSWORD = ".proxyPassword";

    public Request authenticate(Route route, Response response) throws IOException {
        if (response.request().header(PROXY_AUTHORIZATION_HEADER) != null) {
            return null;
        }
        String scheme = route.address().url().scheme();
        String credentials = OkHttpProxyAuthenticator.getCredentials(scheme);
        if (credentials == null) {
            return null;
        }
        return response.request().newBuilder().header(PROXY_AUTHORIZATION_HEADER, credentials).build();
    }

    private static String getCredentials(String protocol) {
        String user = System.getProperty(String.valueOf(protocol.toLowerCase(Locale.ENGLISH)) + PROXY_USER);
        String password = System.getProperty(String.valueOf(protocol.toLowerCase(Locale.ENGLISH)) + PROXY_PASSWORD);
        if (user == null || password == null) {
            return null;
        }
        return Credentials.basic((String)user, (String)password);
    }
}

